﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;

namespace  VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class BprDoDDeploymentFactory : DeploymentAbstractFactory
    {
        //private MilitaryOccupationHistoryManager occupationHistoryManager;
        //public BprDoDDeploymentFactory(MilitaryOccupationHistoryManager mohManager) : base(mohManager) { }

        public BprDoDDeploymentFactory() { }

        public BprDoDDeploymentFactory(string dbConnInfo) : base(dbConnInfo) { }


        protected override IDeployment Create(DoDDeploymentAdapter deployment)
        {
            return new BprDoDDeployment().Create(deployment);
        }
        public override List<IDeployment> CreateDeployments(eMISdeploymentResponseType deploymentResponse, Dictionary<DateRange, string> branchesOfService)// Implementation of Factory Method.
        {
            List<IDeployment> deployments = new List<IDeployment>();
            var history = new MilitaryOccupationHistoryManager(connectionInfo).GetRegistrantHistory(deploymentResponse?.deployment?.First()?.edipi);
            if (deploymentResponse.deployment != null)
            {
                foreach (Deployment emisDeployment in deploymentResponse.deployment)
                {
                    DeploymentData data = emisDeployment.deploymentData;
                    if (data.DeploymentLocation != null)
                    {
                        //var deployment = CreateDeployment(branchOfService, location);
                        foreach (DeploymentLocation location in data.DeploymentLocation)
                        {
                            DoDDeploymentAdapter depAdapter = CreateAdapter(location, branchesOfService);
                            BprDoDDeployment deployment = Create(depAdapter) as BprDoDDeployment;
                            deployments.Add(deployment);
                        }
                    }
                }
            }
            return deployments;
        }

        private DoDDeploymentAdapter CreateAdapter(DeploymentLocation location, Dictionary<DateRange, string> branchesOfService)
        {
            DateRange deploymentDateRange = CreateNewDateRange(location.deploymentLocationBeginDate, location.deploymentLocationEndDate);
            BranchOfService branchOfService = new BranchOfService(location.deploymentLocationBeginDate,
                                            location.deploymentLocationEndDate, branchesOfService);
            DoDDeploymentAdapter deployment = new DoDDeploymentAdapter();
         
            deployment.DutyProjectCode = string.Empty;
            //A deploymentlocation will either have a country OR a major body of water code
            deployment.DeploymentCountry = location.deploymentCountry ?? location.deploymentLocationMajorBodyOfWaterCode;
            deployment.DeploymentStartDate = deploymentDateRange.Start;
            deployment.DeploymentEndDate = deploymentDateRange.End;
            deployment.BranchOfService = branchOfService;
            return deployment;
        }

        public override List<IDeployment> CreateDeployments(eMISdeploymentResponseType deploymentResponse, RegistrantHistory history)
        {
            return CreateDeployments(deploymentResponse, history.BranchesOfService);
        }
    }
}

